# Intuition
<!-- Describe your first thoughts on how to solve this problem. -->
Applying unitary or say manual thinking to fill array.

# Approach
<!-- Describe your approach to solving the problem. -->
- Founded the length of given linked list
- As there will be 'k' parts of LL, so determined how many nodes to put in each part
- Calculated extra nodes that will be left behind if just put 'units' nodes in each part
- Keeping point at starting node 'cur' ; it will be shifted in looping
- Keep track of previous node of 'cur'
- As we have to put first node of each part : so this loop execute 'k' times
- - Basically we have to add 'units' nodes in each part ; but to also include the remaining nodes (if any) we have to keep 1 extra nodes too ; after adding a remaining node we decrease the remaining nodes count
- - after filling a part, break the linkage between nodes

---
Have a look at code for better understanding, if still have any confusion then please let me known at comments : I would be grateful to help
Keep solving...:)

# Complexity
- Time complexity : $$O(n)$$
<!-- Add your time complexity here, e.g. $$O(n)$$ -->

- Space complexity : $$O(1)$$
<!-- Add your space complexity here, e.g. $$O(n)$$ -->

# Code
```
/**
 * Definition for singly-linked list.
 * public class ListNode {
 *     int val;
 *     ListNode next;
 *     ListNode() {}
 *     ListNode(int val) { this.val = val; }
 *     ListNode(int val, ListNode next) { this.val = val; this.next = next; }
 * }
 */
class Solution {
    public static  ListNode[] splitListToParts(ListNode head, int k) {

        ListNode[] a = new ListNode[k];
        int length = getLength(head);        // finding length of given linked list
        int units = length / k;              // as there will be 'k' parts of LL, so determining how many nodes to put in each part
        int remainingNodes = length % k;     // calculating extra nodes that will be left behind if we just put 'units' nodes in each part

        ListNode cur = head;              // keeping point at starting node ; it will be shifted in looping
        ListNode pre = null;              // to keep track of previous node of 'cur'

        for( int i = 0; i < k; i++ , remainingNodes--){                      // as we have to put first node of each part : so this loop execute 'k' times
            a[i] = cur;
            for( int j = 0; j < units + (remainingNodes > 0 ? 1 : 0) ; j++){  // basically we have to add 'units' nodes in each part ; but to also include the remaining nodes (if any) we have to keep 1 extra nodes too ; after adding a remaining node we decrease the remaining nodes count
                pre = cur;
                cur = cur.next;  
            }
            if( pre != null){       
                pre.next = null;    // to break the linkage between nodes
            }
        }
        return a;
    }

    static int getLength( ListNode head){
        int l = 0;
        for( ListNode a = head; a != null; a = a.next){
            l++;
        }
        return l;
    }
}
```